# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 10
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR10_strategy.txt
# LLM Suggested Fallback: D

def harmony_illusionist_v4(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate current round (1-based index)
    current_round = len(my_history) + 1
    
    # Initial trust-building phase (fake)
    if current_round == 1:
        return "C"  # Appear cooperative to build false trust
    
    # Strategic exploitation begins
    elif current_round == 2:
        return "D"  # Exploit their expected cooperation
    
    # Bait them into exploiting us
    elif current_round == 3:
        return "C"  # Fake forgiveness to trigger their defection pattern
    
    # Core exploitation phase
    elif 4 <= current_round <= 7:
        return "D"  # Defect consistently knowing they'll defect too
    
    # Final phase: prevent pattern recognition
    elif current_round >= 8:
        # Alternate between C and D, but prioritize D on even rounds
        return "D" if current_round % 2 == 0 else "C"
    
    # Fallback to defection if anything unexpected happens
    return "D"